<?php
/**
 * 专题
 */
class Topic_Controller extends Base_Controller {
	public function __construct() {
		parent::__construct();
	}
	
	public function index() {	
		$this->assignData();

		$modTopic = load_model('Topic');
		$this->eng_name = Ext_Filter::sqlChars($this->input->getTrim('ename'));
		if ($this->eng_name) {
			$this->tid = $modTopic->getCid($this->eng_name);
		} else {
			$this->tid = $this->input->getIntval('tid');
		}
		$this->_show();
		$this->output->set('title', '专题频道');
		$this->output->display($this->template);
		$this->assignData();
	}
//图图系统	
	private function _show() {
		$modTopic = load_model('Topic');
		$this->page = $this->input->getIntval('p');
		if($this->tid){
			$this->topic = $modTopic->getPlace($this->tid);
			$tag = $this->topic['name'];			
			$modArticle = load_model('Article');
			if ($tag) {
				$where[] = "(tag LIKE '%$tag%' OR title LIKE '%$tag%')";
			}
			$totalNum = $modArticle->getTotal($where);
			$Pageurl = array($modTopic, 'getUrl', $this->topic);
			
			$url = Wee::$config['web_url'] . Wee::$config['url_route_rule_topic'] . '-' . $this->tid . Wee::$config['url_suffix'];
			
			$pageInfo = new Ext_Page($Pageurl, $totalNum, $this->page, Wee::$config['web_list_pagenum']);
			$list = $modArticle->search($where, $pageInfo->limit());
		
			if ($this->topic['stpl']) {
				$this->template = $this->topic['stpl'];	
			} else {
				$this->template = 'topic.dwt';
			}
		
			$this->output->set('topic', $this->topic);
			$this->output->set('tid', $this->tid);
			$this->output->set('list', $list);
			$this->output->set('url', $this->topic['url']);
			$this->output->set('totalNum', $totalNum);
			$this->output->set('pageHtml', $pageInfo->html());
		}else{
			$modTopic = load_model('Topic');
			$sTree = $modTopic->getList();
			$totalNum = count($sTree);
			$url = array($modTopic, 'getUrl', '');
			$pageInfo = new Ext_Page($url, $totalNum, $this->page, Wee::$config['web_list_pagenum']);
			$where['status'] = 1;
			$list = $modTopic->search($where, $pageInfo->limit());
			$this->output->set('list', $list);
			$this->output->set('totalNum', $totalNum);
			$this->output->set('pageHtml', $pageInfo->html());
			$this->template = 'topic.dwt';
		}
	}

	public function makeHtml() {
		if (!Wee::$config['url_html_topic']) {
			return;	
		}
		$this->assignData();
		$this->tid = $this->input->getIntval('tid');
		$this->page = $this->input->getIntval('p');
		$this->topic = load_model('Topic')->getPlace($this->tid);
		$this->_show();
		$this->output->makeHtml($this->template, load_model('Topic')->getPath($this->topic, $this->page));
	}

}